Triggers = {}

include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/end_trigger")
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/kill_watcher")

Triggers["center_point"] = 
{
	active = false, 
	effect_radius = 20, 
	position = { x = 150.73, y = 172.0, z = 14, f = 1.0}, 
	priority = 1.0, 
	think = "tf_center_point", 
	type = "quest", 
}

Triggers["betray_01"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_betray_01", 
	type = "quest", 
}

Triggers["betray_02"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_betray_02", 
	type = "quest", 
}

Triggers["bank_patrol_0"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "circle", 
	point_count = 14, 
	point_radius = 0.5, 
	position = { x = 114.9, y = 132.2, z = 14.8, f = 1.0}, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "none", 
	wait_time = 0, 
	patrol_points = {{ x=114.912, y=132.158, z=14.7934},{ x=121.844, y=137.815, z=14.912},{ x=137.308, y=138.389, z=15.0958},{ x=140.945, y=147.331, z=14.726},{ x=125.001, y=150.786, z=14.8162},{ x=130.537, y=158.84, z=14.677},{ x=118.712, y=165.919, z=14.613},{ x=104.726, y=170.754, z=14.4381},{ x=94.8247, y=170.462, z=14.6558},{ x=84.5787, y=162.65, z=14.6707},{ x=82.7533, y=148.384, z=14.5753},{ x=83.4653, y=141.999, z=14.6183},{ x=89.7641, y=135.791, z=14.6843},{ x=103.759, y=131.833, z=14.74} }
}

Triggers["campaign"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=-51, x=-40.8, z=4.8, f=1 }, 
	priority = 1, 
	think = "tf_campaign", 
	type = "quest", 
}

Triggers["corp_set"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_corp_set", 
	type = "quest", 
}

Triggers["guard_patrol_01"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "circle", 
	point_count = 9, 
	point_radius = 0.5, 
	position = { y=65.1, x=49.1, z=11.9, f=1 }, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "none", 
	wait_time = 0, 
	patrol_points = {{ x=49.0965, y=65.1391, z=11.9297},{ x=65.7537, y=62.3175, z=10.9617},{ x=66.7036, y=61.7907, z=10.9694},{ x=83.8909, y=60.0858, z=10.7613},{ x=95.5725, y=60.1093, z=10.6233},{ x=108.983, y=65.0529, z=10.7988},{ x=120.005, y=59.8937, z=10.3755},{ x=142.002, y=56.1222, z=9.35573},{ x=148.534, y=64.919, z=11.3669} }
}

Triggers["militia_patrol_01"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "circle", 
	point_count = 14, 
	point_radius = 0.5, 
	position = { y=148.6, x=62.7, z=15, f=1 }, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "each", 
	wait_time = 1, 
	patrol_points = {{ x=62.651, y=148.626, z=15.0303},{ x=65.923, y=154.902, z=15.0659},{ x=64.1678, y=162.586, z=15.212},{ x=55.0929, y=168.275, z=15.6641},{ x=55.5452, y=173.998, z=16.2331},{ x=50.6745, y=179.467, z=17.1796},{ x=45.3708, y=176.871, z=17.2198},{ x=43.6502, y=173.947, z=16.9264},{ x=35.0156, y=175.449, z=18.1701},{ x=29.0306, y=171.661, z=18.1592},{ x=29.5187, y=164.707, z=17.1829},{ x=32.2045, y=149.982, z=16.4442},{ x=44.0466, y=142.278, z=15.5169},{ x=52.3844, y=148.884, z=15.3311} }
}

Triggers["militia_patrol_02"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "circle", 
	point_count = 17, 
	point_radius = 0.5, 
	position = { y=143.8, x=52.2, z=15.3, f=1 }, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "each", 
	wait_time = 2, 
	patrol_points = {{ x=52.1801, y=143.834, z=15.2709},{ x=39.6686, y=141.01, z=15.6205},{ x=29.6617, y=152.923, z=16.4886},{ x=26.0586, y=162.461, z=17.2215},{ x=21.2983, y=169.616, z=18.6219},{ x=26.7265, y=178, z=19.1786},{ x=39.3478, y=184.871, z=19.7973},{ x=41.9963, y=194.252, z=21.323},{ x=49.6789, y=195.148, z=21.7046},{ x=59.5328, y=187.093, z=17.6265},{ x=72.0455, y=188.816, z=15.1735},{ x=71.7637, y=176.574, z=15.1811},{ x=82.4302, y=177.891, z=14.9299},{ x=85.0138, y=166.293, z=14.6957},{ x=75.7243, y=159.163, z=14.7878},{ x=61.8568, y=154.043, z=15.164},{ x=64.8109, y=143.244, z=14.8289} }
}

Triggers["militia_set"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_militia_set", 
	type = "quest", 
}

Triggers["on_start"] = 
{
	active = true, 
	effect_radius = 6, 
	position = { y=168.8, x=11.8, z=20.4, f=1 }, 
	priority = 1, 
	think = "tf_on_start", 
	type = "quest", 
}

Triggers["relations_vs_militia"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_relations_vs_militia", 
	type = "quest", 
}

Triggers["relations_vs_mafia"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_relations_vs_mafia", 
	type = "quest", 
}

Triggers["relations_vs_guards"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_relations_vs_guards", 
	type = "quest", 
}

Triggers["support_mafia"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_support_mafia", 
	type = "quest", 
}

Triggers["support_guards"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_support_guards", 
	type = "quest", 
}

Triggers["support_militia"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_support_militia", 
	type = "quest", 
}

Triggers["mafia_reward"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_mafia_reward", 
	type = "quest", 
}

Triggers["guards_reward"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_guards_reward", 
	type = "quest", 
}

Triggers["militia_reward"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_militia_reward", 
	type = "quest", 
}


trigger_functions =
{
tf_betray_01 = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
--		storyline("betray_01")
	end
end,
tf_betray_02 = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
--		storyline("betray_02")
	end
end,
tf_campaign = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
		if ARMY == Sectors.coastal_city.owner then
			Triggers["militia_set"].active = true
		end	
		if CORP == Sectors.coastal_city.owner then
			Triggers["corp_set"].active = true
		end	
	end
end,
tf_corp_set = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
	end
end,
tf_militia_set = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
	end
end,
tf_on_start = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if(trigger_utility.isPlayerPresent(trigger_id,PLAYER) ) then			
			Triggers["campaign"].active = true
			trigger.active = false
		end
	end
end,
tf_relations_vs_militia = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
--		changeLocalRelations(ENEMY, "militia")
--		Sectors.coastal_city.militia_isEnemy = true
		trigger.active = false
	end
end,
tf_relations_vs_mafia = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
--		changeLocalRelations(ENEMY, "mafia")
--		Sectors.coastal_city.mafia_isEnemy = true
		trigger.active = false
	end
end,
tf_relations_vs_guards = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
--		changeLocalRelations(ENEMY, "guards")
--		Sectors.coastal_city.guards_isEnemy = true
		trigger.active = false
	end
end,
tf_support_mafia = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
--		changeLocalRelations(ENEMY, "guards")
--		changeLocalRelations(ENEMY, "militia")		
--		changeLocalRelations(ALLY, "mafia")
--		
--		Sectors.coastal_city.guards_isEnemy = true
--		Sectors.coastal_city.militia_isEnemy = true
--		Sectors.coastal_city.supported_side = 3
		trigger.active = false
	end
end,
tf_support_guards = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
--		changeLocalRelations(ALLY, "guards")
--		changeLocalRelations(ENEMY, "militia")		
--		changeLocalRelations(ENEMY, "mafia")
		
--		Sectors.coastal_city.mafia_isEnemy = true
--		Sectors.coastal_city.militia_isEnemy = true
--		Sectors.coastal_city.supported_side = 4
		trigger.active = false
	end
end,
tf_support_militia = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
--		changeLocalRelations(ENEMY, "guards")
--		changeLocalRelations(ALLY, "militia")		
--		changeLocalRelations(ENEMY, "mafia")
		
--		Sectors.coastal_city.guards_isEnemy = true
--		Sectors.coastal_city.mafia_isEnemy = true
--		Sectors.coastal_city.supported_side = 2
		trigger.active = false
	end
end,
tf_mafia_reward = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
--		storyline("ccity_mafia_reward")
	end
end,
tf_guards_reward = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
--		storyline("ccity_guards_reward")
	end
end,
tf_militia_reward = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
--		storyline("ccity_militia_reward")
	end
end,
--
-- end trigger
--
tf_end_trigger = CommonTriggers.end_trigger,
--
-- kill watcher trigger
--
tf_kill_watcher = CommonTriggers.kill_watcher,
--
-- honey point for bees
--
tf_center_point = CommonTriggers.center_point,
}
